/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.ItemStackMekanismInventory;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.IFrequencyItem;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PortableQIODashboardInventory
extends ItemStackMekanismInventory
implements IQIOCraftingWindowHolder {
    @Nullable
    private final Level world;
    private QIOCraftingWindow[] craftingWindows;

    public PortableQIODashboardInventory(ItemStack stack, @NotNull Inventory inv) {
        super(stack);
        this.world = inv.f_35978_.m_9236_();
        for (QIOCraftingWindow craftingWindow : this.craftingWindows) {
            craftingWindow.invalidateRecipe();
        }
    }

    @Override
    protected List<IInventorySlot> getInitialInventory() {
        ArrayList<IInventorySlot> slots = new ArrayList<IInventorySlot>();
        this.craftingWindows = new QIOCraftingWindow[3];
        for (byte tableIndex = 0; tableIndex < this.craftingWindows.length; tableIndex = (byte)(tableIndex + 1)) {
            QIOCraftingWindow craftingWindow;
            this.craftingWindows[tableIndex] = craftingWindow = new QIOCraftingWindow(this, tableIndex);
            for (int slot = 0; slot < 9; ++slot) {
                slots.add(craftingWindow.getInputSlot(slot));
            }
            slots.add(craftingWindow.getOutputSlot());
        }
        return slots;
    }

    @Override
    @Nullable
    public Level getHolderWorld() {
        return this.world;
    }

    @Override
    public QIOCraftingWindow[] getCraftingWindows() {
        return this.craftingWindows;
    }

    @Override
    @Nullable
    public QIOFrequency getFrequency() {
        IFrequencyItem frequencyItem;
        if (this.world != null && !this.world.m_5776_() && (frequencyItem = (IFrequencyItem)this.stack.m_41720_()).hasFrequency(this.stack)) {
            Frequency frequency = frequencyItem.getFrequency(this.stack);
            if (frequency instanceof QIOFrequency) {
                QIOFrequency freq = (QIOFrequency)frequency;
                return freq;
            }
            frequencyItem.setFrequency(this.stack, null);
        }
        return null;
    }
}

