/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.bin;

import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.recipe.bin.BinRecipe;
import mekanism.common.registries.MekanismRecipeSerializers;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

@NothingNullByDefault
public class BinExtractRecipe
extends BinRecipe {
    public BinExtractRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ItemStack binStack = this.findBinStack(inv);
        if (binStack.m_41619_()) {
            return false;
        }
        return !BinExtractRecipe.convertToSlot(binStack).isEmpty();
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack binStack = this.findBinStack(inv);
        if (binStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return BinExtractRecipe.convertToSlot(binStack).getBottomStack();
    }

    private ItemStack findBinStack(CraftingContainer inv) {
        ItemStack binStack = ItemStack.f_41583_;
        int slots = inv.m_6643_();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (stackInSlot.m_41720_() instanceof ItemBlockBin) {
                if (!binStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                binStack = stackInSlot;
                continue;
            }
            return ItemStack.f_41583_;
        }
        return binStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        int slots = inv.m_6643_();
        NonNullList remaining = NonNullList.m_122780_((int)slots, (Object)ItemStack.f_41583_);
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (!(stackInSlot.m_41720_() instanceof ItemBlockBin)) continue;
            ItemStack binStack = stackInSlot.m_41777_();
            BinInventorySlot slot = BinExtractRecipe.convertToSlot(binStack);
            ItemStack bottomStack = slot.getBottomStack();
            if (bottomStack.m_41619_()) break;
            MekanismUtils.logMismatchedStackSize(slot.shrinkStack(bottomStack.m_41613_(), Action.EXECUTE), bottomStack.m_41613_());
            remaining.set(i, (Object)binStack);
            break;
        }
        return remaining;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MekanismRecipeSerializers.BIN_EXTRACT.get();
    }
}

