/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.interfaces;

import java.util.function.Supplier;
import mekanism.client.render.hud.MekanismStatusOverlay;
import mekanism.common.Mekanism;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import mekanism.common.network.to_client.PacketShowModeChange;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IModeItem {
    public void changeMode(@NotNull Player var1, @NotNull ItemStack var2, int var3, DisplayChange var4);

    default public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return slotType == EquipmentSlot.MAINHAND || slotType == EquipmentSlot.OFFHAND;
    }

    @Nullable
    default public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return null;
    }

    public static boolean isModeItem(@NotNull Player player, @NotNull EquipmentSlot slotType) {
        return IModeItem.isModeItem(player, slotType, true);
    }

    public static boolean isModeItem(@NotNull Player player, @NotNull EquipmentSlot slotType, boolean allowRadial) {
        return IModeItem.isModeItem(player.m_6844_(slotType), slotType, allowRadial);
    }

    public static boolean isModeItem(@NotNull ItemStack stack, @NotNull EquipmentSlot slotType) {
        return IModeItem.isModeItem(stack, slotType, true);
    }

    public static boolean isModeItem(@NotNull ItemStack stack, @NotNull EquipmentSlot slotType, boolean allowRadial) {
        IModeItem modeItem;
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IModeItem && (modeItem = (IModeItem)item).supportsSlotType(stack, slotType)) {
            IGenericRadialModeItem radialModeItem;
            return allowRadial || !(modeItem instanceof IGenericRadialModeItem) || (radialModeItem = (IGenericRadialModeItem)modeItem).getRadialData(stack) == null;
        }
        return false;
    }

    public static void displayModeChange(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Mekanism.packetHandler().sendTo(PacketShowModeChange.INSTANCE, serverPlayer);
        } else {
            MekanismStatusOverlay.INSTANCE.setTimer();
        }
    }

    public static enum DisplayChange {
        NONE,
        MAIN_HAND,
        OTHER;


        public void sendMessage(Player player, Supplier<Component> message) {
            if (this == MAIN_HAND) {
                IModeItem.displayModeChange(player);
            } else if (this == OTHER) {
                player.m_213846_(MekanismUtils.logFormat(message.get()));
            }
        }
    }
}

