/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item;

import com.lothrazar.library.item.ItemFlib;
import com.lothrazar.storagenetwork.StorageNetworkMod;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.util.UtilInventory;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import org.apache.commons.lang3.tuple.Triple;

public class ItemCollector
extends ItemFlib {
    public static final String NBT_BOUND = "bound";
    private static final String NBT_ENABLED = "Enabled";

    public ItemCollector(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    protected ItemStack findAmmo(Player player, Item item) {
        Triple<String, Integer, ItemStack> remote = UtilInventory.getCurioRemote(player, item);
        return (ItemStack)remote.getRight();
    }

    public void toggleEnabled(ItemStack stack, Player player) {
        boolean enabled = stack.m_41784_().m_128471_(NBT_ENABLED);
        stack.m_41784_().m_128379_(NBT_ENABLED, !enabled);
        player.m_5661_((Component)Component.m_237113_((String)("Collector " + (!enabled ? "enabled" : "disabled"))), true);
    }

    public void onEntityItemPickupEvent(EntityItemPickupEvent event) {
        if (event.getEntity() instanceof Player && event.getItem() != null && !event.getItem().m_32055_().m_41619_()) {
            Player player = event.getEntity();
            ItemStack collectorStack = this.findAmmo(player, (Item)this);
            if (collectorStack.m_41619_()) {
                return;
            }
            CompoundTag tag = collectorStack.m_41784_();
            if (!tag.m_128471_(NBT_ENABLED)) {
                return;
            }
            ItemStack item = event.getItem().m_32055_();
            Level world = player.m_9236_();
            DimPos dp = DimPos.getPosStored(collectorStack);
            if (dp != null && !world.f_46443_) {
                ServerLevel serverTargetWorld = DimPos.stringDimensionLookup(dp.getDimension(), world.m_7654_());
                if (serverTargetWorld == null) {
                    StorageNetworkMod.LOGGER.error("Missing dimension key " + dp.getDimension());
                    return;
                }
                BlockEntity tile = serverTargetWorld.m_7702_(dp.getBlockPos());
                if (tile instanceof TileMain) {
                    TileMain network = (TileMain)tile;
                    int countUnmoved = network.insertStack(item.m_41777_(), false);
                    item.m_41764_(countUnmoved);
                    if (countUnmoved == 0) {
                        UtilTileEntity.playSoundFromServer((ServerPlayer)player, SoundEvents.f_12019_, 0.2f);
                    }
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world.m_7702_(pos) instanceof TileMain) {
            ItemStack stack = player.m_21120_(hand);
            DimPos.putPos(stack, pos, world);
            UtilTileEntity.statusMessage(player, "item.remote.connected");
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        DimPos dp;
        MutableComponent t = Component.m_237115_((String)(this.m_5524_() + ".tooltip"));
        t.m_130940_(ChatFormatting.GRAY);
        tooltip.add((Component)t);
        if (stack.m_41782_() && (dp = DimPos.getPosStored(stack)) != null) {
            tooltip.add(dp.makeTooltip());
        }
    }
}

