/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.api.ITileNetworkSync;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkCraftingRemote;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkRemote;
import com.lothrazar.storagenetwork.item.remote.ItemRemote;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SettingsSyncMessage {
    private BlockPos pos;
    private boolean direction;
    private EnumSortType sort;
    private boolean targetTileEntity;
    private boolean jeiSync;
    private boolean autoFocus;

    private SettingsSyncMessage() {
    }

    public SettingsSyncMessage(BlockPos pos, boolean direction, EnumSortType sort, boolean jeiSync, boolean autoFocus) {
        this.pos = pos;
        this.direction = direction;
        this.sort = sort;
        this.jeiSync = jeiSync;
        this.autoFocus = autoFocus;
    }

    public static void handle(SettingsSyncMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (message.targetTileEntity) {
                BlockEntity tileEntity = player.m_9236_().m_7702_(message.pos);
                if (tileEntity instanceof ITileNetworkSync) {
                    ITileNetworkSync tile = (ITileNetworkSync)tileEntity;
                    tile.setSort(message.sort);
                    tile.setDownwards(message.direction);
                    tile.setJeiSearchSynced(message.jeiSync);
                    tile.setAutoFocus(message.autoFocus);
                    tileEntity.m_6596_();
                }
            } else {
                AbstractContainerMenu patt1966$temp = player.f_36096_;
                if (patt1966$temp instanceof ContainerNetworkCraftingRemote) {
                    ContainerNetworkCraftingRemote remoteContainer = (ContainerNetworkCraftingRemote)patt1966$temp;
                    stackPlayerHeld = remoteContainer.getRemote();
                    if (stackPlayerHeld.m_41720_() instanceof ItemRemote) {
                        ItemRemote.setSort(stackPlayerHeld, message.sort);
                        ItemRemote.setDownwards(stackPlayerHeld, message.direction);
                        ItemRemote.setJeiSearchSynced(stackPlayerHeld, message.jeiSync);
                        ItemRemote.setAutoFocus(stackPlayerHeld, message.autoFocus);
                    }
                } else {
                    ContainerNetworkRemote rcc;
                    AbstractContainerMenu patt2496$temp = player.f_36096_;
                    if (patt2496$temp instanceof ContainerNetworkRemote && (stackPlayerHeld = (rcc = (ContainerNetworkRemote)patt2496$temp).getRemote()).m_41720_() instanceof ItemRemote) {
                        ItemRemote.setSort(stackPlayerHeld, message.sort);
                        ItemRemote.setDownwards(stackPlayerHeld, message.direction);
                        ItemRemote.setJeiSearchSynced(stackPlayerHeld, message.jeiSync);
                        ItemRemote.setAutoFocus(stackPlayerHeld, message.autoFocus);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static SettingsSyncMessage decode(FriendlyByteBuf buf) {
        SettingsSyncMessage message = new SettingsSyncMessage();
        message.direction = buf.readBoolean();
        int sort = buf.readInt();
        message.sort = EnumSortType.values()[sort];
        message.targetTileEntity = buf.readBoolean();
        message.pos = buf.m_130135_();
        message.jeiSync = buf.readBoolean();
        message.autoFocus = buf.readBoolean();
        return message;
    }

    public static void encode(SettingsSyncMessage msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.direction);
        buf.writeInt(msg.sort.ordinal());
        if (msg.pos != null) {
            buf.writeBoolean(true);
            buf.m_130064_(msg.pos);
        } else {
            buf.writeBoolean(false);
            buf.m_130064_(BlockPos.f_121853_);
        }
        buf.writeBoolean(msg.jeiSync);
        buf.writeBoolean(msg.autoFocus);
    }
}

